<?php

namespace App\Extensions\MarketingBot\System\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CampaignConversion extends Model
{
    protected $table = 'ext_campaign_conversions';

    protected $fillable = [
        'campaign_id',
        'shopify_order_id',
        'revenue',
        'utm_source',
        'utm_medium',
        'utm_campaign',
        'utm_term',
        'utm_content',
        'conversion_type',
        'converted_at',
    ];

    protected $casts = [
        'revenue' => 'decimal:2',
        'converted_at' => 'datetime',
    ];

    /**
     * Get the campaign that owns this conversion
     */
    public function campaign(): BelongsTo
    {
        return $this->belongsTo(MarketingCampaign::class, 'campaign_id');
    }

    /**
     * Get the order for this conversion
     */
    public function order(): BelongsTo
    {
        return $this->belongsTo(ShopifyOrder::class, 'shopify_order_id');
    }

    /**
     * Scope for conversions from a specific date range
     */
    public function scopeDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('converted_at', [$startDate, $endDate]);
    }

    /**
     * Scope for direct conversions
     */
    public function scopeDirect($query)
    {
        return $query->where('conversion_type', 'direct');
    }

    /**
     * Scope for assisted conversions
     */
    public function scopeAssisted($query)
    {
        return $query->where('conversion_type', 'assisted');
    }
}
